/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.runtime.internal.repository.metadata.loader;

import com.ibm.db2.cmx.runtime.internal.repository.metadata.Constants;
import com.ibm.db2.cmx.runtime.internal.repository.metadata.SourceInfo;
import com.ibm.db2.cmx.runtime.internal.repository.metadata.loader.DbInfoCache;
import com.ibm.db2.cmx.runtime.internal.repository.metadata.loader.ExplainSQLInfo;
import com.ibm.db2.cmx.runtime.internal.repository.metadata.loader.MetadataCacheResults;
import com.ibm.db2.cmx.runtime.internal.repository.metadata.loader.MetadataSourceStmtCache;
import com.ibm.db2.cmx.runtime.internal.repository.metadata.loader.SavedExplainData;
import com.ibm.db2.cmx.runtime.internal.repository.metadata.loader.SourceTableCache;
import com.ibm.db2.cmx.runtime.internal.repository.util.ExpandableIntArray;
import com.ibm.db2.cmx.runtime.internal.repository.util.SortedExpandableIntArray;
import java.util.HashSet;
import java.util.List;

public class MetadataCache {
    private SourceTableCache sourceCache = new SourceTableCache();
    private StatementCache stmtCache = new StatementCache();
    private RelationshipCache relationshipCache = new RelationshipCache();
    private DbInfoCache dbInfoCache = new DbInfoCache();
    private MetadataSourceStmtCache mdSourceStmtCache = new MetadataSourceStmtCache();
    private SavedExplainData explainData = null;
    private Integer projectKey = null;
    private boolean projectKeySet = false;
    private Integer appKey = null;
    private Integer metadataSourceKey = null;

    public MetadataCacheResults searchCache(List<SourceInfo> list, Constants.SourceOpType sourceOpType, String string, String string2) {
        MetadataCacheResults metadataCacheResults = new MetadataCacheResults();
        metadataCacheResults.projectKey = this.projectKey;
        metadataCacheResults.projectNew = !this.projectKeySet;
        metadataCacheResults.metadataSrcKey = this.metadataSourceKey;
        this.processStmt(metadataCacheResults, string);
        this.processSource(metadataCacheResults, list);
        this.processRelationships(metadataCacheResults, sourceOpType);
        this.processPackageInfo(metadataCacheResults, string2);
        this.processMetadataSourceInfo(metadataCacheResults);
        return metadataCacheResults;
    }

    public void addToSourceCache(int n2, List<SourceInfo> list) {
        this.sourceCache.add(n2, list);
    }

    public void addToStmtCache(int n2, String string) {
        this.stmtCache.add(n2, string);
    }

    public void addToPackageInfoCache(int n2, String string) {
        this.dbInfoCache.add(n2, string);
    }

    public void addToSrcStmtCache(int n2, int n3, Constants.SourceOpType sourceOpType, Integer n4) {
        this.relationshipCache.addRelationship(n2, sourceOpType, n3, n4);
    }

    public void addToMetadataSourceStmtCache(int n2, int n3, Integer n4, Integer n5) {
        this.mdSourceStmtCache.add(n2, n3, n4, n5);
    }

    public void setAppKey(Integer n2) {
        this.appKey = n2;
    }

    public Integer getAppKey() {
        return this.appKey;
    }

    public void setProjectKey(Integer n2) {
        this.projectKey = n2;
        this.projectKeySet = true;
    }

    public void clearProjectKey() {
        this.projectKey = null;
        this.projectKeySet = false;
    }

    public static String generateStmtTextKey(String string, String string2, String string3, String string4, boolean bl2, String string5, String string6, boolean bl3, String string7, String string8, String string9) {
        return MetadataCache.generateStmtTextKey(MetadataCache.generatePackageTextKey(string, string2, string3, string4, bl2), string5, string6, bl3, string7, string8, string9);
    }

    public static String generateStmtTextKey(String string, String string2, String string3, boolean bl2, String string4, String string5, String string6) {
        StringBuilder stringBuilder = new StringBuilder(string);
        MetadataCache.addString(string3, stringBuilder, "<null_expr>");
        MetadataCache.addString(string2, stringBuilder, "<null_sql>");
        if (bl2) {
            stringBuilder.append('Y');
        } else {
            stringBuilder.append('N');
        }
        MetadataCache.addString(string4, stringBuilder, "<null_defaultSchema>");
        MetadataCache.addString(string5, stringBuilder, "<null_CallPath>");
        MetadataCache.addString(string6, stringBuilder, "<null_SpecReg>");
        return stringBuilder.toString();
    }

    public static String generatePackageTextKey(String string, String string2, String string3, String string4, boolean bl2) {
        return DbInfoCache.generatePackageTextKey(string, string2, string3, string4, bl2);
    }

    public void setMetadataSourceKey(Integer n2) {
        this.metadataSourceKey = n2;
    }

    public void setSavedExplainData(SavedExplainData savedExplainData) {
        this.explainData = savedExplainData;
    }

    public ExplainSQLInfo getExplainValuesFor(String string) {
        ExplainSQLInfo explainSQLInfo = null;
        if (this.explainData != null) {
            explainSQLInfo = this.explainData.getExplainData(string);
        }
        return explainSQLInfo;
    }

    public void notifyKeysCreated(MetadataCacheResults metadataCacheResults) {
        if (this.metadataSourceKey == null) {
            this.metadataSourceKey = metadataCacheResults.metadataSrcKey;
        }
        if (metadataCacheResults.projectNew) {
            this.setProjectKey(metadataCacheResults.projectKey);
        }
        if (metadataCacheResults.statementNew) {
            this.stmtCache.add(metadataCacheResults.stmtKey, metadataCacheResults.stmtKeyText);
        }
        if (metadataCacheResults.newStack != null && metadataCacheResults.stackKey != null) {
            this.sourceCache.add(metadataCacheResults.stackKey, metadataCacheResults.newStack);
        }
        if (metadataCacheResults.relationshipNew && metadataCacheResults.relationshipOpType != null) {
            this.relationshipCache.addRelationship(metadataCacheResults.stmtKey, metadataCacheResults.relationshipOpType, metadataCacheResults.stackKey, this.appKey);
        }
        if (metadataCacheResults.dbInfoNew) {
            this.dbInfoCache.add(metadataCacheResults.dbInfoKey, metadataCacheResults.dbInfoText);
        }
        if (metadataCacheResults.mdSrcStmtNew) {
            this.mdSourceStmtCache.add(metadataCacheResults.stmtKey, metadataCacheResults.metadataSrcKey, metadataCacheResults.projectKey, this.appKey);
        }
    }

    private static void addString(String string, StringBuilder stringBuilder, String string2) {
        if (string != null) {
            stringBuilder.append(string.trim());
        } else {
            stringBuilder.append(string2);
        }
    }

    private void processStmt(MetadataCacheResults metadataCacheResults, String string) {
        boolean bl2;
        if (string == null) {
            return;
        }
        long l2 = this.stmtCache.getKey(string);
        boolean bl3 = bl2 = l2 != Long.MIN_VALUE;
        if (bl2) {
            metadataCacheResults.stmtKey = (int)l2;
            metadataCacheResults.statementNew = false;
        } else {
            metadataCacheResults.statementNew = true;
            metadataCacheResults.stmtKeyText = string;
        }
    }

    private void processSource(MetadataCacheResults metadataCacheResults, List<SourceInfo> list) {
        metadataCacheResults.newStack = null;
        metadataCacheResults.stackKey = null;
        if (list == null) {
            return;
        }
        Integer n2 = 0;
        SourceInfo sourceInfo = null;
        for (int i10 = 0; i10 < list.size() && sourceInfo == null; ++i10) {
            SourceInfo sourceInfo2 = list.get(i10);
            n2 = this.sourceCache.searchFor(sourceInfo2);
            if (n2 == null) continue;
            sourceInfo = sourceInfo2;
        }
        if (sourceInfo != null) {
            metadataCacheResults.stackKey = (int)n2;
        } else {
            n2 = this.sourceCache.searchFor(list);
            if (n2 != null) {
                metadataCacheResults.stackKey = n2;
            } else {
                metadataCacheResults.newStack = list;
            }
        }
    }

    private void processRelationships(MetadataCacheResults metadataCacheResults, Constants.SourceOpType sourceOpType) {
        if (sourceOpType == null) {
            return;
        }
        metadataCacheResults.relationshipOpType = sourceOpType;
        metadataCacheResults.relationshipNew = metadataCacheResults.statementNew || metadataCacheResults.newStack != null || metadataCacheResults.stackKey == null ? true : !this.relationshipCache.doesRelationshipExist(metadataCacheResults.stmtKey, sourceOpType, metadataCacheResults.stackKey, this.appKey);
    }

    private void processPackageInfo(MetadataCacheResults metadataCacheResults, String string) {
        if (string != null) {
            metadataCacheResults.dbInfoKey = this.dbInfoCache.searchFor(string);
            metadataCacheResults.dbInfoNew = metadataCacheResults.dbInfoKey == null;
            metadataCacheResults.dbInfoText = string;
        } else {
            metadataCacheResults.dbInfoKey = null;
            metadataCacheResults.dbInfoNew = false;
        }
    }

    private void processMetadataSourceInfo(MetadataCacheResults metadataCacheResults) {
        boolean bl2 = true;
        if (!metadataCacheResults.statementNew && !metadataCacheResults.projectNew && metadataCacheResults.metadataSrcKey != null) {
            bl2 = !this.mdSourceStmtCache.contains(metadataCacheResults.stmtKey, metadataCacheResults.metadataSrcKey, metadataCacheResults.projectKey, this.appKey);
        }
        metadataCacheResults.mdSrcStmtNew = bl2;
    }

    public Integer getMetadataSrcKey() {
        return this.metadataSourceKey;
    }

    public DbInfoCache getDbInfoCache() {
        return this.dbInfoCache;
    }

    public SourceTableCache getSourceTableCache() {
        return this.sourceCache;
    }

    public MetadataSourceStmtCache getMetadataSourceStmtCache() {
        return this.mdSourceStmtCache;
    }

    private static class StatementCache {
        private SortedExpandableIntArray keyValues = new SortedExpandableIntArray();
        private ExpandableIntArray keys = new ExpandableIntArray();

        private StatementCache() {
        }

        public void add(int n2, String string) {
            this.keyValues.add(string.hashCode());
            this.keys.add(n2);
        }

        public long getKey(String string) {
            int n2 = this.keyValues.searchFor(string.hashCode());
            if (n2 >= 0) {
                return this.keys.get(n2);
            }
            return Long.MIN_VALUE;
        }
    }

    private static class RelationshipCache {
        private HashSet<Relationship> existingRelationships = new HashSet();
        private Relationship tempRelationship = new Relationship();

        private RelationshipCache() {
        }

        public void addRelationship(int n2, Constants.SourceOpType sourceOpType, int n3, Integer n4) {
            Relationship relationship = new Relationship();
            relationship.stmtKey = n2;
            relationship.opType = sourceOpType;
            relationship.srcKey = n3;
            relationship.appKey = n4;
            this.existingRelationships.add(relationship);
        }

        public boolean doesRelationshipExist(int n2, Constants.SourceOpType sourceOpType, int n3, Integer n4) {
            this.tempRelationship.stmtKey = n2;
            this.tempRelationship.opType = sourceOpType;
            this.tempRelationship.srcKey = n3;
            this.tempRelationship.appKey = n4;
            return this.existingRelationships.contains(this.tempRelationship);
        }

        private static class Relationship {
            private int stmtKey = 0;
            private Constants.SourceOpType opType = null;
            private int srcKey = 0;
            private Integer appKey = null;

            private Relationship() {
            }

            public boolean equals(Object object) {
                boolean bl2 = false;
                if (object != null && object instanceof Relationship) {
                    Relationship relationship = (Relationship)object;
                    bl2 = this.stmtKey == relationship.stmtKey && this.srcKey == relationship.srcKey && (this.opType == relationship.opType || this.opType != null && this.opType.equals((Object)relationship.opType)) && (this.appKey == relationship.appKey || this.appKey != null && this.appKey.equals(relationship.appKey));
                }
                return bl2;
            }

            public int hashCode() {
                return this.stmtKey + this.srcKey;
            }
        }
    }
}

