/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.linter;

import java.sql.Connection;
import java.util.Collection;
import java.util.Objects;
import schemacrawler.schema.Column;
import schemacrawler.schema.Table;
import schemacrawler.tools.lint.BaseLinter;
import schemacrawler.tools.lint.LintCollector;
import schemacrawler.utility.MetaDataUtility;
import us.fatehi.utility.property.PropertyName;

class LinterTableAllNullableColumns
extends BaseLinter {
    LinterTableAllNullableColumns(PropertyName propertyName, LintCollector lintCollector) {
        super(propertyName, lintCollector);
    }

    @Override
    public String getSummary() {
        return "no non-nullable data columns";
    }

    @Override
    protected void lint(Table table, Connection connection) {
        Objects.requireNonNull(table, "No table provided");
        if (!MetaDataUtility.isView((Table)table) && this.hasAllNullableColumns(this.getColumns(table))) {
            this.addTableLint(table, this.getSummary());
        }
    }

    private boolean hasAllNullableColumns(Collection<Column> columns) {
        boolean hasAllNullableColumns = true;
        for (Column column : columns) {
            if (column.isPartOfPrimaryKey() || column.isNullable()) continue;
            hasAllNullableColumns = false;
            break;
        }
        return hasAllNullableColumns;
    }
}

