/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset.transform;

import ucar.nc2.Variable;
import ucar.nc2.dataset.CoordinateTransform;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.ProjectionCT;
import ucar.nc2.dataset.TransformType;
import ucar.nc2.dataset.transform.AbstractCoordTransBuilder;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.projection.proj4.AlbersEqualAreaEllipse;

public class AlbersEqualArea
extends AbstractCoordTransBuilder {
    @Override
    public String getTransformName() {
        return "albers_conical_equal_area";
    }

    @Override
    public TransformType getTransformType() {
        return TransformType.Projection;
    }

    @Override
    public CoordinateTransform makeCoordinateTransform(NetcdfDataset ds, Variable ctv) {
        double[] pars = this.readAttributeDouble2(ctv.findAttribute("standard_parallel"));
        if (pars == null) {
            return null;
        }
        this.readStandardParams(ds, ctv);
        ProjectionImpl proj = this.earth != null ? new AlbersEqualAreaEllipse(this.lat0, this.lon0, pars[0], pars[1], this.false_easting, this.false_northing, this.earth) : new ucar.unidata.geoloc.projection.AlbersEqualArea(this.lat0, this.lon0, pars[0], pars[1], this.false_easting, this.false_northing, this.earth_radius);
        return new ProjectionCT(ctv.getShortName(), "FGDC", proj);
    }
}

