/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.logs;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Value;
import io.opentelemetry.api.incubator.common.ExtendedAttributeKey;
import io.opentelemetry.api.incubator.logs.ExtendedLogRecordBuilder;
import io.opentelemetry.api.logs.Severity;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import io.opentelemetry.sdk.internal.ExtendedAttributesMap;
import io.opentelemetry.sdk.logs.ExtendedSdkReadWriteLogRecord;
import io.opentelemetry.sdk.logs.LoggerSharedState;
import io.opentelemetry.sdk.logs.SdkLogRecordBuilder;
import java.time.Instant;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

final class ExtendedSdkLogRecordBuilder
extends SdkLogRecordBuilder
implements ExtendedLogRecordBuilder {
    @Nullable
    private ExtendedAttributesMap extendedAttributes;

    ExtendedSdkLogRecordBuilder(LoggerSharedState loggerSharedState, InstrumentationScopeInfo instrumentationScopeInfo) {
        super(loggerSharedState, instrumentationScopeInfo);
    }

    @Override
    public ExtendedSdkLogRecordBuilder setEventName(String eventName) {
        super.setEventName(eventName);
        return this;
    }

    public ExtendedSdkLogRecordBuilder setException(Throwable throwable) {
        if (throwable == null) {
            return this;
        }
        this.loggerSharedState.getExceptionAttributeResolver().setExceptionAttributes((attributeKey, object) -> this.setAttribute(attributeKey, object), throwable, this.loggerSharedState.getLogLimits().getMaxAttributeValueLength());
        return this;
    }

    @Override
    public ExtendedSdkLogRecordBuilder setTimestamp(long timestamp, TimeUnit unit) {
        super.setTimestamp(timestamp, unit);
        return this;
    }

    @Override
    public ExtendedSdkLogRecordBuilder setTimestamp(Instant instant) {
        super.setTimestamp(instant);
        return this;
    }

    @Override
    public ExtendedSdkLogRecordBuilder setObservedTimestamp(long timestamp, TimeUnit unit) {
        super.setObservedTimestamp(timestamp, unit);
        return this;
    }

    @Override
    public ExtendedSdkLogRecordBuilder setObservedTimestamp(Instant instant) {
        super.setObservedTimestamp(instant);
        return this;
    }

    @Override
    public ExtendedSdkLogRecordBuilder setContext(Context context) {
        super.setContext(context);
        return this;
    }

    @Override
    public ExtendedSdkLogRecordBuilder setSeverity(Severity severity) {
        super.setSeverity(severity);
        return this;
    }

    @Override
    public ExtendedSdkLogRecordBuilder setSeverityText(String severityText) {
        super.setSeverityText(severityText);
        return this;
    }

    @Override
    public ExtendedSdkLogRecordBuilder setBody(String body) {
        super.setBody(body);
        return this;
    }

    @Override
    public ExtendedSdkLogRecordBuilder setBody(Value<?> value) {
        super.setBody((Value)value);
        return this;
    }

    public <T> ExtendedSdkLogRecordBuilder setAttribute(ExtendedAttributeKey<T> key, T value) {
        if (key == null || key.getKey().isEmpty() || value == null) {
            return this;
        }
        if (this.extendedAttributes == null) {
            this.extendedAttributes = ExtendedAttributesMap.create((long)this.logLimits.getMaxNumberOfAttributes(), (int)this.logLimits.getMaxAttributeValueLength());
        }
        this.extendedAttributes.put(key, value);
        return this;
    }

    @Override
    public <T> ExtendedSdkLogRecordBuilder setAttribute(AttributeKey<T> key, @Nullable T value) {
        if (key == null || key.getKey().isEmpty() || value == null) {
            return this;
        }
        return this.setAttribute(ExtendedAttributeKey.fromAttributeKey(key), (Object)value);
    }

    @Override
    public void emit() {
        if (this.loggerSharedState.hasBeenShutdown()) {
            return;
        }
        Context context = this.context == null ? Context.current() : this.context;
        long observedTimestampEpochNanos = this.observedTimestampEpochNanos == 0L ? this.loggerSharedState.getClock().now() : this.observedTimestampEpochNanos;
        this.loggerSharedState.getLogRecordProcessor().onEmit(context, ExtendedSdkReadWriteLogRecord.create(this.loggerSharedState.getLogLimits(), this.loggerSharedState.getResource(), this.instrumentationScopeInfo, this.eventName, this.timestampEpochNanos, observedTimestampEpochNanos, Span.fromContext((Context)context).getSpanContext(), this.severity, this.severityText, this.body, this.extendedAttributes));
    }
}

