/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texosquery;

import com.dickimawbooks.texosquery.FileSortType;
import com.dickimawbooks.texosquery.FileWalkVisitor;
import com.dickimawbooks.texosquery.TeXOSQuery;
import java.io.File;
import java.io.IOException;
import java.util.Calendar;
import java.util.Locale;

public class TeXOSQueryJRE7
extends TeXOSQuery {
    public TeXOSQueryJRE7() {
        super("texosquery");
    }

    @Override
    protected File checkDirectoryListing(File file) throws IOException {
        if ((file = file.getCanonicalFile()).getParentFile() == null) {
            throw new IOException(String.format("Listing on root directory not permitted: %s", file));
        }
        File file2 = new File(this.getSystemProperty("user.dir", "."));
        if (!file2.equals(file) && !this.isFileInTree(file, file2)) {
            throw new IOException(String.format("Listing outside cwd path not permitted: %s", file));
        }
        return file;
    }

    @Override
    public String walk(String string, String string2, File file, FileSortType fileSortType) {
        try {
            return FileWalkVisitor.walk(this, string, string2, file, fileSortType);
        }
        catch (Exception exception) {
            this.debug(String.format("Can't walk directory: %s", file.toString()), exception);
            return "";
        }
    }

    @Override
    public String getScript(Locale locale) {
        return locale.getScript();
    }

    @Override
    public Locale getLocale(String string) {
        Locale locale = Locale.forLanguageTag(string);
        String string2 = locale.getCountry();
        try {
            string2 = this.getRegionAlpha2Code(Integer.parseInt(string2));
        }
        catch (NumberFormatException numberFormatException) {
            return locale;
        }
        Locale.Builder builder = new Locale.Builder();
        builder.setLocale(locale);
        builder.setRegion(string2);
        return builder.build();
    }

    @Override
    public String getLanguageTag(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return locale.toLanguageTag();
    }

    @Override
    public int getWeekYear(Calendar calendar) {
        try {
            return calendar.isWeekDateSupported() ? calendar.getWeekYear() : calendar.get(1);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            this.debug(unsupportedOperationException.getMessage(), unsupportedOperationException);
            return calendar.get(1);
        }
    }

    public static void main(String[] stringArray) {
        try {
            new TeXOSQueryJRE7().processArgs(stringArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println(illegalArgumentException.getMessage());
            System.exit(1);
        }
    }
}

