/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.alert;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.parosproxy.paros.Constant;
import org.zaproxy.zap.extension.alert.AlertTagsTableModel;
import org.zaproxy.zap.utils.ZapTextArea;
import org.zaproxy.zap.utils.ZapTextField;
import org.zaproxy.zap.view.AbstractFormDialog;
import org.zaproxy.zap.view.LayoutHelper;

public class DialogAddAlertTag
extends AbstractFormDialog {
    private static final long serialVersionUID = 1L;
    private static final String DIALOG_TITLE = Constant.messages.getString("alert.tags.dialog.add.title");
    private static final String CONFIRM_BUTTON_LABEL = Constant.messages.getString("alert.tags.dialog.add.button.confirm");
    private static final String KEY_FIELD_LABEL = Constant.messages.getString("alert.tags.dialog.add.key");
    private static final String VALUE_FIELD_LABEL = Constant.messages.getString("alert.tags.dialog.add.value");
    private static final String REPEATED_TAG_KEY_TITLE = Constant.messages.getString("alert.tags.dialog.warning.title.repeated.key");
    private static final String REPEATED_TAG_KEY_BODY = Constant.messages.getString("alert.tags.dialog.warning.body.repeated.key");
    protected static final int MAX_KEY_LENGTH = 1024;
    protected static final int MAX_VALUE_LENGTH = 4000;
    private ZapTextField keyTextField;
    private ZapTextArea valueTextArea;
    private JScrollPane valueTextAreaScrollPane;
    private ConfirmButtonValidatorDocListener confirmButtonValidatorDocListener;
    protected AlertTagsTableModel model;

    public DialogAddAlertTag(Dialog owner, AlertTagsTableModel model) {
        this(owner, model, DIALOG_TITLE);
    }

    protected DialogAddAlertTag(Dialog owner, AlertTagsTableModel model, String title) {
        super(owner, title);
        this.model = model;
    }

    @Override
    protected JPanel getFieldsPanel() {
        JPanel fieldsPanel = new JPanel(new GridBagLayout());
        JLabel keyLabel = new JLabel(KEY_FIELD_LABEL);
        JLabel valueLabel = new JLabel(VALUE_FIELD_LABEL);
        int gbcRow = 0;
        fieldsPanel.add((Component)keyLabel, LayoutHelper.getGBC(0, gbcRow, 1, 0.0, 0.1, 2, new Insets(2, 2, 2, 2)));
        fieldsPanel.add((Component)this.getKeyTextField(), LayoutHelper.getGBC(1, gbcRow, 1, 1.0, 0.1, 2, new Insets(2, 2, 2, 2)));
        fieldsPanel.add((Component)valueLabel, LayoutHelper.getGBC(0, ++gbcRow, 1, 0.0, 0.1, 2, new Insets(2, 2, 2, 2)));
        fieldsPanel.add((Component)this.getValueTextAreaScrollPane(), LayoutHelper.getGBC(0, ++gbcRow, 2, 1.0, 0.5, 1, new Insets(2, 2, 2, 2)));
        return fieldsPanel;
    }

    @Override
    protected String getConfirmButtonLabel() {
        return CONFIRM_BUTTON_LABEL;
    }

    @Override
    protected void init() {
        this.getKeyTextField().setText("");
        this.getValueTextArea().setText("");
    }

    @Override
    protected boolean validateFields() {
        return this.validateKey() && this.validateValue();
    }

    protected boolean validateKey() {
        String key = this.getKeyTextField().getText().trim();
        if (this.model.getTags().containsKey(key)) {
            JOptionPane.showMessageDialog(this, REPEATED_TAG_KEY_BODY, REPEATED_TAG_KEY_TITLE, 1);
            this.getKeyTextField().requestFocusInWindow();
            return false;
        }
        int len = this.getKeyTextField().getDocument().getLength();
        return len > 0 && len <= 1024;
    }

    protected boolean validateValue() {
        return this.getValueTextArea().getDocument().getLength() <= 4000;
    }

    @Override
    protected void performAction() {
        this.model.addTag(this.getKeyTextField().getText(), this.getValueTextArea().getText());
    }

    @Override
    protected void clearFields() {
        this.getKeyTextField().setText("");
        this.getKeyTextField().discardAllEdits();
        this.getValueTextArea().setText("");
        this.getValueTextArea().discardAllEdits();
    }

    protected ZapTextField getKeyTextField() {
        if (this.keyTextField == null) {
            this.keyTextField = new ZapTextField(20);
            this.keyTextField.getDocument().addDocumentListener(this.getConfirmButtonValidatorDocListener());
        }
        return this.keyTextField;
    }

    protected ZapTextArea getValueTextArea() {
        if (this.valueTextArea == null) {
            this.valueTextArea = new ZapTextArea(5, 20);
            this.valueTextArea.setLineWrap(true);
            this.valueTextArea.getDocument().addDocumentListener(this.getConfirmButtonValidatorDocListener());
        }
        return this.valueTextArea;
    }

    protected JScrollPane getValueTextAreaScrollPane() {
        if (this.valueTextAreaScrollPane == null) {
            this.valueTextAreaScrollPane = new JScrollPane(this.getValueTextArea());
            this.valueTextAreaScrollPane.setHorizontalScrollBarPolicy(31);
            this.valueTextAreaScrollPane.setVerticalScrollBarPolicy(20);
        }
        return this.valueTextAreaScrollPane;
    }

    private ConfirmButtonValidatorDocListener getConfirmButtonValidatorDocListener() {
        if (this.confirmButtonValidatorDocListener == null) {
            this.confirmButtonValidatorDocListener = new ConfirmButtonValidatorDocListener();
        }
        return this.confirmButtonValidatorDocListener;
    }

    private class ConfirmButtonValidatorDocListener
    implements DocumentListener {
        private ConfirmButtonValidatorDocListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.checkAndEnableConfirmButton();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.checkAndEnableConfirmButton();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.checkAndEnableConfirmButton();
        }

        private void checkAndEnableConfirmButton() {
            int keyLen = DialogAddAlertTag.this.getKeyTextField().getDocument().getLength();
            int valueLen = DialogAddAlertTag.this.getValueTextArea().getDocument().getLength();
            boolean enabled = keyLen > 0 && keyLen <= 1024 && valueLen <= 4000;
            DialogAddAlertTag.this.setConfirmButtonEnabled(enabled);
        }
    }
}

