/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.ui.menubuilders.menu;

import java.awt.Component;
import javax.swing.ButtonGroup;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.IFreeplaneAction;
import org.freeplane.core.ui.components.JAutoRadioButtonMenuItem;
import org.freeplane.core.ui.menubuilders.action.AcceleratebleActionProvider;
import org.freeplane.core.ui.menubuilders.action.IAcceleratorMap;
import org.freeplane.core.ui.menubuilders.generic.Entry;
import org.freeplane.core.ui.menubuilders.generic.EntryAccessor;
import org.freeplane.core.ui.menubuilders.generic.ResourceAccessor;
import org.freeplane.core.ui.menubuilders.menu.ComponentProvider;
import org.freeplane.core.ui.menubuilders.menu.IconReplacer;

public class MenuRadioActionComponentProvider
implements ComponentProvider {
    private IAcceleratorMap accelerators;
    private AcceleratebleActionProvider acceleratebleActionProvider;
    private EntryAccessor entryAccessor;
    private ButtonGroup buttonGroup;

    public MenuRadioActionComponentProvider(IAcceleratorMap accelerators, AcceleratebleActionProvider acceleratebleActionProvider, ResourceAccessor resourceAccessor, ButtonGroup buttonGroup) {
        this.accelerators = accelerators;
        this.acceleratebleActionProvider = acceleratebleActionProvider;
        this.buttonGroup = buttonGroup;
        this.entryAccessor = new EntryAccessor(resourceAccessor);
    }

    @Override
    public Component createComponent(Entry entry) {
        AFreeplaneAction action = this.entryAccessor.getAction(entry);
        if (action != null) {
            IFreeplaneAction wrappedAction = this.acceleratebleActionProvider.wrap(action);
            JRadioButtonMenuItem actionComponent = action.isSelectable() ? new JAutoRadioButtonMenuItem(wrappedAction, this.buttonGroup) : new JRadioButtonMenuItem(wrappedAction);
            this.buttonGroup.add(actionComponent);
            KeyStroke accelerator = this.accelerators.getAccelerator(action);
            actionComponent.setAccelerator(accelerator);
            if (this.entryAccessor.shouldRemoveMenuIcon(entry)) {
                actionComponent.setIcon(null);
            } else {
                IconReplacer.replaceByScaledImageIcon(actionComponent);
            }
            return actionComponent;
        }
        if (entry.builders().contains("separator")) {
            return new JPopupMenu.Separator();
        }
        return null;
    }
}

