/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.markerlayer;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.actions.AutoScaleAction;
import org.openstreetmap.josm.actions.RenameLayerAction;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.GpxExtension;
import org.openstreetmap.josm.data.gpx.GpxLink;
import org.openstreetmap.josm.data.gpx.IGpxLayerPrefs;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.data.imagery.street_level.IImageEntry;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.QuadBuckets;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.data.preferences.IntegerProperty;
import org.openstreetmap.josm.data.preferences.NamedColorProperty;
import org.openstreetmap.josm.data.preferences.StrokeProperty;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.CustomizeColor;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.JumpToMarkerActions;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.MapViewPaintable;
import org.openstreetmap.josm.gui.layer.geoimage.IGeoImageLayer;
import org.openstreetmap.josm.gui.layer.geoimage.RemoteEntry;
import org.openstreetmap.josm.gui.layer.gpx.ConvertFromMarkerLayerAction;
import org.openstreetmap.josm.gui.layer.markerlayer.AudioMarker;
import org.openstreetmap.josm.gui.layer.markerlayer.ImageMarker;
import org.openstreetmap.josm.gui.layer.markerlayer.Marker;
import org.openstreetmap.josm.gui.layer.markerlayer.PlayHeadMarker;
import org.openstreetmap.josm.gui.preferences.display.GPXSettingsPanel;
import org.openstreetmap.josm.io.audio.AudioPlayer;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.ColorHelper;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.ListenerList;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public class MarkerLayer
extends Layer
implements JumpToMarkerActions.JumpToMarkerLayer,
IGeoImageLayer {
    public final MarkerData data;
    private boolean mousePressed;
    public GpxLayer fromLayer;
    private Marker currentMarker;
    public AudioMarker syncAudioMarker;
    private Color color;
    private Color realcolor;
    final int markerSize = new IntegerProperty("draw.rawgps.markers.size", 4).get();
    final BasicStroke markerStroke = (BasicStroke)new StrokeProperty("draw.rawgps.markers.stroke", "1").get();
    private final ListenerList<IGeoImageLayer.ImageChangeListener> imageChangeListenerListenerList = ListenerList.create();
    private MarkerMouseAdapter mouseAdapter;
    private MapView mapView;
    public static final NamedColorProperty DEFAULT_COLOR_PROPERTY = new NamedColorProperty(I18n.marktr("gps marker"), Color.magenta);

    public MarkerLayer(GpxData indata, String name, File associatedFile, GpxLayer fromLayer) {
        super(name);
        this.setAssociatedFile(associatedFile);
        this.data = new MarkerData();
        this.fromLayer = fromLayer;
        double firstTime = -1.0;
        String lastLinkedFile = "";
        if (fromLayer == null || fromLayer.data == null) {
            this.data.ownLayerPrefs = indata.getLayerPrefs();
        }
        String cs = GPXSettingsPanel.tryGetDataPrefLocal(this.data, "markers.color");
        Color c = null;
        if (cs != null && (c = ColorHelper.html2color(cs)) == null) {
            Logging.warn("Could not read marker color: " + cs);
        }
        this.setPrivateColors(c);
        for (WayPoint wpt : indata.waypoints) {
            Collection<Marker> markers;
            double time = wpt.getTime();
            boolean wptHasLink = wpt.attr.containsKey("meta.links");
            if (firstTime < 0.0 && wptHasLink) {
                firstTime = time;
                Iterator iterator = wpt.getCollection("meta.links").iterator();
                if (iterator.hasNext()) {
                    GpxLink oneLink = (GpxLink)iterator.next();
                    lastLinkedFile = oneLink.uri;
                }
            }
            if (wptHasLink) {
                for (GpxLink oneLink : wpt.getCollection("meta.links")) {
                    String uri = oneLink.uri;
                    if (uri == null) continue;
                    if (!uri.equals(lastLinkedFile)) {
                        firstTime = time;
                    }
                    lastLinkedFile = uri;
                    break;
                }
            }
            Double offset = null;
            GpxExtension offsetExt = wpt.getExtensions().get("josm", "offset");
            if (offsetExt != null && offsetExt.getValue() != null) {
                try {
                    offset = Double.valueOf(offsetExt.getValue());
                }
                catch (NumberFormatException nfe) {
                    Logging.warn(nfe);
                }
            }
            if (offset == null) {
                offset = time - firstTime;
            }
            if ((markers = Marker.createMarkers(wpt, indata.storageFile, this, time, offset)) == null) continue;
            this.data.addAll((Collection<? extends Marker>)markers);
        }
    }

    @Override
    public synchronized void destroy() {
        if (this.data.contains(AudioMarker.recentlyPlayedMarker())) {
            AudioMarker.resetRecentlyPlayedMarker();
        }
        this.syncAudioMarker = null;
        this.currentMarker = null;
        this.fromLayer = null;
        this.data.forEach(Marker::destroy);
        this.data.clear();
        if (this.mouseAdapter != null && this.mapView != null) {
            this.mapView.removeMouseListener(this.mouseAdapter);
        }
        super.destroy();
    }

    @Override
    public MapViewPaintable.LayerPainter attachToMapView(MapViewPaintable.MapViewEvent event) {
        if (this.mapView != null) {
            Logging.warn("MarkerLayer was already attached to a MapView");
        }
        this.mapView = event.getMapView();
        this.mouseAdapter = new MarkerMouseAdapter();
        this.mapView.addMouseListener(this.mouseAdapter);
        if (event.getMapView().playHeadMarker == null) {
            event.getMapView().playHeadMarker = PlayHeadMarker.create();
        }
        return super.attachToMapView(event);
    }

    @Override
    public Icon getIcon() {
        return ImageProvider.get("layer", "marker_small");
    }

    @Override
    public void paint(Graphics2D g, MapView mv, Bounds box) {
        boolean showTextOrIcon = this.isTextOrIconShown();
        g.setColor(this.realcolor);
        if (this.mousePressed) {
            boolean mousePressedTmp = this.mousePressed;
            Point mousePos = mv.getMousePosition();
            for (Marker mkr : this.data) {
                if (mousePos == null || !mkr.containsPoint(mousePos)) continue;
                mkr.paint(g, mv, mousePressedTmp, showTextOrIcon);
                mousePressedTmp = false;
            }
        } else {
            for (Marker mkr : this.data) {
                mkr.paint(g, mv, false, showTextOrIcon);
            }
        }
    }

    @Override
    public String getToolTipText() {
        return Integer.toString(this.data.size()) + " " + I18n.trn("marker", "markers", this.data.size(), new Object[0]);
    }

    @Override
    public void mergeFrom(Layer from) {
        if (from instanceof MarkerLayer) {
            this.data.addAll(((MarkerLayer)from).data);
            this.data.sort(Comparator.comparingDouble(o -> o.time));
        }
    }

    @Override
    public boolean isMergable(Layer other) {
        return other instanceof MarkerLayer;
    }

    @Override
    public void visitBoundingBox(BoundingXYVisitor v) {
        for (Marker mkr : this.data) {
            v.visit(mkr);
        }
    }

    @Override
    public Object getInfoComponent() {
        return "<html>" + I18n.trn("{0} consists of {1} marker", "{0} consists of {1} markers", this.data.size(), Utils.escapeReservedCharactersHTML(this.getName()), this.data.size()) + "</html>";
    }

    @Override
    public Action[] getMenuEntries() {
        ArrayList<Action> components = new ArrayList<Action>();
        components.add(LayerListDialog.getInstance().createShowHideLayerAction());
        components.add(new ShowHideMarkerText(this));
        components.add(LayerListDialog.getInstance().createDeleteLayerAction());
        components.add(MainApplication.getMenu().autoScaleActions.get((Object)AutoScaleAction.AutoScaleMode.LAYER));
        components.add(LayerListDialog.getInstance().createMergeLayerAction(this));
        components.add(Layer.SeparatorLayerAction.INSTANCE);
        components.add(new CustomizeColor(this));
        components.add(Layer.SeparatorLayerAction.INSTANCE);
        components.add(new SynchronizeAudio());
        if (Config.getPref().getBoolean("marker.traceaudio", true)) {
            components.add(new MoveAudio());
        }
        components.add(new JumpToMarkerActions.JumpToNextMarker(this));
        components.add(new JumpToMarkerActions.JumpToPreviousMarker(this));
        components.add(new ConvertFromMarkerLayerAction(this));
        components.add(new RenameLayerAction(this.getAssociatedFile(), this));
        components.add(Layer.SeparatorLayerAction.INSTANCE);
        components.add(new LayerListPopup.InfoAction(this));
        return components.toArray(new Action[0]);
    }

    public boolean synchronizeAudioMarkers(AudioMarker startMarker) {
        this.syncAudioMarker = startMarker;
        if (this.syncAudioMarker != null && !this.data.contains(this.syncAudioMarker)) {
            this.syncAudioMarker = null;
        }
        if (this.syncAudioMarker == null) {
            this.syncAudioMarker = Utils.filteredCollection(this.data, AudioMarker.class).stream().findFirst().orElse(this.syncAudioMarker);
        }
        if (this.syncAudioMarker == null) {
            return false;
        }
        double adjustment = AudioPlayer.position() - this.syncAudioMarker.offset;
        boolean seenStart = false;
        try {
            URI uri = this.syncAudioMarker.url().toURI();
            for (Marker m : this.data) {
                AudioMarker ma;
                if (m == this.syncAudioMarker) {
                    seenStart = true;
                }
                if (!seenStart || !(m instanceof AudioMarker) || !(ma = (AudioMarker)m).url().toURI().equals(uri)) continue;
                ma.adjustOffset(adjustment);
            }
        }
        catch (URISyntaxException e) {
            Logging.warn(e);
        }
        return true;
    }

    public AudioMarker addAudioMarker(double time, LatLon coor) {
        double offset = 0.0;
        AudioMarker am = null;
        for (Marker m : this.data) {
            if (m.getClass() != AudioMarker.class) continue;
            am = (AudioMarker)m;
            offset = time - am.time;
            break;
        }
        if (am == null) {
            JOptionPane.showMessageDialog(MainApplication.getMainFrame(), I18n.tr("No existing audio markers in this layer to offset from.", new Object[0]), I18n.tr("Error", new Object[0]), 0);
            return null;
        }
        AudioMarker newAudioMarker = new AudioMarker(coor, null, AudioPlayer.url(), this, time, offset);
        ArrayList<Marker> newData = new ArrayList<Marker>();
        am = null;
        AudioMarker ret = newAudioMarker;
        for (Marker m : this.data) {
            if (m.getClass() == AudioMarker.class) {
                am = (AudioMarker)m;
                if (newAudioMarker != null && offset < am.offset) {
                    newAudioMarker.adjustOffset(am.syncOffset());
                    newData.add(newAudioMarker);
                    newAudioMarker = null;
                }
            }
            newData.add(m);
        }
        if (newAudioMarker != null) {
            if (am != null) {
                newAudioMarker.adjustOffset(am.syncOffset());
            }
            newData.add(newAudioMarker);
        }
        this.data.clear();
        this.data.addAll((Collection<? extends Marker>)newData);
        return ret;
    }

    @Override
    public void jumpToNextMarker() {
        if (this.currentMarker == null) {
            this.currentMarker = this.data.get(0);
        } else {
            boolean foundCurrent = false;
            for (Marker m : this.data) {
                if (foundCurrent) {
                    this.currentMarker = m;
                    break;
                }
                if (this.currentMarker != m) continue;
                foundCurrent = true;
            }
        }
        MainApplication.getMap().mapView.zoomTo(this.currentMarker);
    }

    @Override
    public void jumpToPreviousMarker() {
        if (this.currentMarker == null) {
            this.currentMarker = this.data.get(this.data.size() - 1);
        } else {
            boolean foundCurrent = false;
            for (int i = this.data.size() - 1; i >= 0; --i) {
                Marker m = this.data.get(i);
                if (foundCurrent) {
                    this.currentMarker = m;
                    break;
                }
                if (this.currentMarker != m) continue;
                foundCurrent = true;
            }
        }
        MainApplication.getMap().mapView.zoomTo(this.currentMarker);
    }

    void setCurrentMarker(Marker newMarker) {
        this.currentMarker = newMarker;
    }

    public static void playAudio() {
        MarkerLayer.playAdjacentMarker(null, true);
    }

    public static void playNextMarker() {
        MarkerLayer.playAdjacentMarker(AudioMarker.recentlyPlayedMarker(), true);
    }

    public static void playPreviousMarker() {
        MarkerLayer.playAdjacentMarker(AudioMarker.recentlyPlayedMarker(), false);
    }

    private static Marker getAdjacentMarker(Marker startMarker, boolean next, Layer layer) {
        Marker previousMarker = null;
        boolean nextTime = false;
        if (layer.getClass() == MarkerLayer.class) {
            MarkerLayer markerLayer = (MarkerLayer)layer;
            for (Marker marker : markerLayer.data) {
                if (marker == startMarker) {
                    if (next) {
                        nextTime = true;
                        continue;
                    }
                    if (previousMarker == null) {
                        previousMarker = startMarker;
                    }
                    return previousMarker;
                }
                if (marker.getClass() != AudioMarker.class) continue;
                if (nextTime || startMarker == null) {
                    return marker;
                }
                previousMarker = marker;
            }
            if (nextTime) {
                return startMarker;
            }
        }
        return null;
    }

    private static void playAdjacentMarker(Marker startMarker, boolean next) {
        if (!MainApplication.isDisplayingMapView()) {
            return;
        }
        Marker m = null;
        Layer l = MainApplication.getLayerManager().getActiveLayer();
        if (l != null) {
            m = MarkerLayer.getAdjacentMarker(startMarker, next, l);
        }
        if (m == null) {
            Layer layer;
            Iterator<Layer> iterator = MainApplication.getLayerManager().getLayers().iterator();
            while (iterator.hasNext() && (m = MarkerLayer.getAdjacentMarker(startMarker, next, layer = iterator.next())) == null) {
            }
        }
        if (m != null) {
            ((AudioMarker)m).play();
        }
    }

    private boolean isTextOrIconShown() {
        return Boolean.parseBoolean(GPXSettingsPanel.getDataPref(this.data, "markers.show-text"));
    }

    @Override
    public boolean hasColor() {
        return true;
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public void setColor(Color color) {
        this.setPrivateColors(color);
        String cs = null;
        if (color != null) {
            cs = ColorHelper.color2html(color);
        }
        GPXSettingsPanel.putDataPrefLocal(this.data, "markers.color", cs);
        this.invalidate();
    }

    private void setPrivateColors(Color color) {
        this.color = color;
        this.realcolor = Optional.ofNullable(color).orElse(DEFAULT_COLOR_PROPERTY.get());
    }

    @Override
    public void clearSelection() {
        this.currentMarker = null;
    }

    @Override
    public List<? extends IImageEntry<?>> getSelection() {
        RemoteEntry remoteEntry;
        if (this.currentMarker instanceof ImageMarker && (remoteEntry = ((ImageMarker)this.currentMarker).getRemoteEntry()) != null) {
            return Collections.singletonList(remoteEntry);
        }
        return Collections.emptyList();
    }

    @Override
    public boolean containsImage(IImageEntry<?> imageEntry) {
        if (imageEntry instanceof RemoteEntry) {
            RemoteEntry entry = (RemoteEntry)imageEntry;
            if (entry.getPos() != null && entry.getPos().isLatLonKnown()) {
                List<Marker> markers = this.data.search(new BBox(entry.getPos()));
                return MarkerLayer.checkIfListContainsEntry(markers, entry);
            }
            if (entry.getExifCoor() != null && entry.getExifCoor().isLatLonKnown()) {
                List<Marker> markers = this.data.search(new BBox(entry.getExifCoor()));
                return MarkerLayer.checkIfListContainsEntry(markers, entry);
            }
            return MarkerLayer.checkIfListContainsEntry(this.data, entry);
        }
        return false;
    }

    private static boolean checkIfListContainsEntry(List<Marker> markerList, RemoteEntry imageEntry) {
        for (Marker marker : markerList) {
            if (!(marker instanceof ImageMarker)) continue;
            ImageMarker imageMarker = (ImageMarker)marker;
            try {
                if (!Objects.equals(imageMarker.imageUrl.toURI(), imageEntry.getImageURI())) continue;
                return true;
            }
            catch (URISyntaxException e) {
                Logging.trace(e);
            }
        }
        return false;
    }

    @Override
    public void addImageChangeListener(IGeoImageLayer.ImageChangeListener listener) {
        this.imageChangeListenerListenerList.addListener(listener);
    }

    @Override
    public void removeImageChangeListener(IGeoImageLayer.ImageChangeListener listener) {
        this.imageChangeListenerListenerList.removeListener(listener);
    }

    public class MarkerData
    extends QuadBuckets<Marker>
    implements List<Marker>,
    IGpxLayerPrefs {
        private Map<String, String> ownLayerPrefs;
        private final List<Marker> markerList = new ArrayList<Marker>();

        @Override
        public Map<String, String> getLayerPrefs() {
            if (this.ownLayerPrefs == null && MarkerLayer.this.fromLayer != null && MarkerLayer.this.fromLayer.data != null) {
                return MarkerLayer.this.fromLayer.data.getLayerPrefs();
            }
            if (this.ownLayerPrefs == null) {
                this.ownLayerPrefs = new HashMap<String, String>();
            }
            return this.ownLayerPrefs;
        }

        public void transferLayerPrefs(Map<String, String> gpxLayerPrefs) {
            this.ownLayerPrefs = new HashMap<String, String>(gpxLayerPrefs);
        }

        @Override
        public void setModified(boolean value) {
            if (MarkerLayer.this.fromLayer != null && MarkerLayer.this.fromLayer.data != null) {
                MarkerLayer.this.fromLayer.data.setModified(value);
            }
        }

        @Override
        public boolean addAll(int index, Collection<? extends Marker> c) {
            c.forEach(this::add);
            return this.markerList.addAll(index, c);
        }

        @Override
        public boolean addAll(Collection<? extends Marker> objects) {
            return this.markerList.addAll(objects) && super.addAll(objects);
        }

        @Override
        public Marker get(int index) {
            return this.markerList.get(index);
        }

        @Override
        public Marker set(int index, Marker element) {
            Marker original = this.markerList.set(index, element);
            this.remove(original);
            return original;
        }

        @Override
        public void add(int index, Marker element) {
            this.add(element);
            this.markerList.add(index, element);
        }

        @Override
        public Marker remove(int index) {
            Marker toRemove = this.markerList.remove(index);
            this.remove(toRemove);
            return toRemove;
        }

        @Override
        public int indexOf(Object o) {
            return this.markerList.indexOf(o);
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.markerList.lastIndexOf(o);
        }

        @Override
        public ListIterator<Marker> listIterator() {
            return this.markerList.listIterator();
        }

        @Override
        public ListIterator<Marker> listIterator(int index) {
            return this.markerList.listIterator(index);
        }

        @Override
        public List<Marker> subList(int fromIndex, int toIndex) {
            return this.markerList.subList(fromIndex, toIndex);
        }

        @Override
        public boolean retainAll(Collection<?> objects) {
            return this.markerList.retainAll(objects) && super.retainAll(objects);
        }

        @Override
        public boolean contains(Object o) {
            return this.markerList.contains(o) && super.contains(o);
        }
    }

    private class MoveAudio
    extends AbstractAction {
        MoveAudio() {
            super(I18n.tr("Make Audio Marker at Play Head", new Object[0]));
            new ImageProvider("addmarkers").getResource().attachImageIcon(this, true);
            this.putValue("help", HelpUtil.ht("/Action/MakeAudioMarkerAtPlayHead"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!AudioPlayer.paused()) {
                JOptionPane.showMessageDialog(MainApplication.getMainFrame(), I18n.tr("You need to have paused audio at the point on the track where you want the marker.", new Object[0]), I18n.tr("Warning", new Object[0]), 2);
                return;
            }
            PlayHeadMarker playHeadMarker = MainApplication.getMap().mapView.playHeadMarker;
            if (playHeadMarker == null) {
                return;
            }
            MarkerLayer.this.addAudioMarker(playHeadMarker.time, playHeadMarker.getCoor());
            MarkerLayer.this.invalidate();
        }
    }

    private class SynchronizeAudio
    extends AbstractAction {
        SynchronizeAudio() {
            super(I18n.tr("Synchronize Audio", new Object[0]));
            new ImageProvider("audio-sync").getResource().attachImageIcon(this, true);
            this.putValue("help", HelpUtil.ht("/Action/SynchronizeAudio"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!AudioPlayer.paused()) {
                JOptionPane.showMessageDialog(MainApplication.getMainFrame(), I18n.tr("You need to pause audio at the moment when you hear your synchronization cue.", new Object[0]), I18n.tr("Warning", new Object[0]), 2);
                return;
            }
            AudioMarker recent = AudioMarker.recentlyPlayedMarker();
            if (MarkerLayer.this.synchronizeAudioMarkers(recent)) {
                JOptionPane.showMessageDialog(MainApplication.getMainFrame(), I18n.tr("Audio synchronized at point {0}.", MarkerLayer.this.syncAudioMarker.getText()), I18n.tr("Information", new Object[0]), 1);
            } else {
                JOptionPane.showMessageDialog(MainApplication.getMainFrame(), I18n.tr("Unable to synchronize in layer being played.", new Object[0]), I18n.tr("Error", new Object[0]), 0);
            }
        }
    }

    public static final class ShowHideMarkerText
    extends AbstractAction
    implements Layer.LayerAction {
        private final transient MarkerLayer layer;

        public ShowHideMarkerText(MarkerLayer layer) {
            super(I18n.tr("Show Text/Icons", new Object[0]));
            new ImageProvider("dialogs", "showhide").getResource().attachImageIcon(this, true);
            this.putValue("ShortDescription", I18n.tr("Toggle visible state of the marker text and icons.", new Object[0]));
            this.putValue("help", HelpUtil.ht("/Action/ShowHideTextIcons"));
            this.layer = layer;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GPXSettingsPanel.putDataPrefLocal(this.layer.data, "markers.show-text", Boolean.toString(!this.layer.isTextOrIconShown()));
            this.layer.invalidate();
        }

        @Override
        public Component createMenuComponent() {
            JCheckBoxMenuItem showMarkerTextItem = new JCheckBoxMenuItem(this);
            showMarkerTextItem.setState(this.layer.isTextOrIconShown());
            return showMarkerTextItem;
        }

        @Override
        public boolean supportLayers(List<Layer> layers) {
            return layers.size() == 1 && layers.get(0) instanceof MarkerLayer;
        }
    }

    private final class MarkerMouseAdapter
    extends MouseAdapter {
        private MarkerMouseAdapter() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getButton() != 1) {
                return;
            }
            boolean mousePressedInButton = MarkerLayer.this.data.stream().anyMatch(mkr -> mkr.containsPoint(e.getPoint()));
            if (!mousePressedInButton) {
                return;
            }
            MarkerLayer.this.mousePressed = true;
            if (MarkerLayer.this.isVisible()) {
                MarkerLayer.this.invalidate();
            }
        }

        @Override
        public void mouseReleased(MouseEvent ev) {
            if (ev.getButton() != 1 || !MarkerLayer.this.mousePressed) {
                return;
            }
            MarkerLayer.this.mousePressed = false;
            if (!MarkerLayer.this.isVisible()) {
                return;
            }
            for (Marker mkr : MarkerLayer.this.data) {
                if (!mkr.containsPoint(ev.getPoint())) continue;
                mkr.actionPerformed(new ActionEvent(this, 0, null));
            }
            MarkerLayer.this.invalidate();
        }
    }
}

