/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.visitor.NodeVisitor;

public class Match3Node
extends Node {
    private final Node receiverNode;
    private final Node valueNode;

    public Match3Node(int line, Node receiverNode, Node valueNode) {
        super(line, receiverNode.containsVariableAssignment() || valueNode.containsVariableAssignment());
        assert (valueNode != null) : "valueNode is not null";
        this.receiverNode = receiverNode;
        this.valueNode = valueNode;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.MATCH3NODE;
    }

    @Override
    public <T> T accept(NodeVisitor<T> iVisitor) {
        return iVisitor.visitMatch3Node(this);
    }

    public Node getReceiverNode() {
        return this.receiverNode;
    }

    public Node getValueNode() {
        return this.valueNode;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.receiverNode, this.valueNode);
    }

    @Override
    public boolean needsDefinitionCheck() {
        return false;
    }
}

